# MoDA Demo

Welcome to the MoDA demo repository. Below you'll find details on how to explore the project, view the demo, and access additional resources.

## Project Structure

- **`moda/`**: Contains the demo videos.
- **`index.html`**: The source code for the demo website. The demo website can be opened using any standard web browser. If the site fails to load, all demo videos are available directly under the moda/ directory for manual playback.
- **`src/`**: Contains the core code for MoDA, which will be released soon.
- **`sup.pdf`**: Additional details and explanations of the MoDA paper.

## Video Showcase

### 1. Introduction Video
Watch the [MoDA Demo Video](moda/moda.mp4) to get an overview of the MoDA framework.

### 2. MoDA vs. Other Systems
Explore videos comparing MoDA with other systems (e.g., EchoMimic, Hallo2, Hallo, JoyHallo, JoyVasa, Ditto):
- [Comparison 1](moda/compara)
- [Comparison 2](moda/compara2)
- [Comparison 3](moda/compara3)
- [Comparison 5](moda/compara5)

### 3. Talking Head Generation in Complex Scenarios
View videos demonstrating Talking Head Generation in complex scenarios:  
[Complex Scenarios](moda/Complex%20Scenarios/)

### 4. Fine-grained Emotion Control
See how MoDA handles fine-grained emotion control in the following videos:  
[Emotion Control](moda/Emotion%20Control)

### 5. Long Videos Generation
Watch MoDA generate long-form videos:  
[Long Videos Generation](moda/Long%20Videos%20Generation)

### 6. Ablation Study
Explore the results of the ablation study conducted on MoDA:  
[Ablation Study](moda/Ablation%20Study)
